using System;
using System.Collections.Generic;
using System.Text;

namespace CannibalProblem
{
    public class CannibalSolver
    {
        private ulong visitedNodes;
        private ulong visitedDistinctNodes;
        private int boatSize;
        private CannibalState initState;
        private CannibalState goalState;
        private List<CannibalState> previousStates;

        public CannibalState InitState
        {
            get
            {
                return initState;
            }
        }

        public CannibalState GoalState
        {
            get
            {
                return goalState;
            }
        }

        public ulong VisitedNodes
        {
            get
            {
                return visitedNodes;
            }
        }

        public ulong VisitedDistinctNodes
        {
            get
            {
                return visitedDistinctNodes;
            }
        }

        public CannibalSolver(CannibalState initState, CannibalState goalState, int boatSize)
        {
            if (boatSize <= 1 || initState.IsValid() == false || goalState.IsValid() == false)
                throw new Exception("Invalid states as parameter");
            this.initState = initState;
            this.goalState = goalState;
            this.boatSize = boatSize;
        }

        private bool Visited(CannibalState state)
        {
            foreach (CannibalState curState in previousStates)
                if (curState.Equals(state))
                    return true;
            return false;
        }

        public List<string> BFS()
        {
            visitedNodes = visitedDistinctNodes = 1;
            if (initState.Equals(goalState))
                return new List<string>();
            Queue<CannibalState> stateQueue = new Queue<CannibalState>();
            previousStates = new List<CannibalState>();
            CannibalState newState;
            CannibalState curState = initState;
            previousStates.Add(curState);
            stateQueue.Enqueue(curState);
            while (stateQueue.Count != 0)
            {
                curState = stateQueue.Dequeue();
                for(int i=0; i<=boatSize; i++)
                    for (int j = 0; j <= boatSize - i; j++)
                    {
                        if (curState.BoatPosition == CannibalState.Position.Right)
                            newState = curState.Right2Left(i, j);
                        else
                            newState = curState.Left2Right(i, j);
                        visitedNodes++;
                        if (newState == null)
                            continue;
                        else if (newState.IsValid() == false)
                            continue;
                        if (newState.Equals(goalState))
                        {
                            visitedDistinctNodes++;
                            return newState.History;
                        }
                        else if(Visited(newState) == false)
                        {
                            visitedDistinctNodes++;
                            stateQueue.Enqueue(newState);
                            previousStates.Add(newState);
                        }
                    }
            }
            return null;
        }
    }
}
